//+------------------------------------------------------------------+
//|                                            JC - DynPeriod MA.mq4 |
//|                                          Juan Carlos Christensen |
//|                                     http://www.eumefinancial.com |
//+------------------------------------------------------------------+
#property copyright "Juan Carlos Christensen"
#property link      "http://www.eumefinancial.com"

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Red
#property indicator_width1 3

extern string Main_Modes = "0=ATR; 1=ATRJMA; 2=StdDev; 3=Simple";
extern int Main_Mode = 0;
extern string MA_Modes = "0=SMA; 1=EMA; 2=SMMA; 3=LWMA; 4=JMA";
extern int MA_Mode = 0;
extern int JMA_Phase = 5;
extern int DynPeriod = 14;
extern int Constant = 100;
extern int LookBack = 0;
extern bool Use_StaircaseMode = False;
extern int PipPrecision = 5;
//---- buffers
double DynPeriodMA[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,DynPeriodMA);
   IndicatorDigits(Digits);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   switch(Main_Mode)
   {
      case 0:
         ATRMA();
         break;
      case 1:
         ATRJMA();
         break;
      case 2:
         StdDevMA();
         break;
      case 3:
         SimpleMA();
         break;
      default:
         ATRMA();
    }
//----
   return(0);
  }
//+------------------------------------------------------------------+

void ATRMA()
{
   int counted_bars=IndicatorCounted();
//----
   int pos=Bars-counted_bars;

   double ATR;
   double MA;
   int MA_Period;
   
   if(Use_StaircaseMode == False) PipPrecision = 1;

   if(MA_Mode == 0 || MA_Mode == 1 || MA_Mode == 2 || MA_Mode == 3)
   {
      while(pos>=0)
      { 
         ATR = iATR(NULL, 0, DynPeriod, pos + LookBack);        
 
         if (ATR != 0) {
            MA_Period = (1/ATR)  / Constant;
         } else {
            MA_Period = 1;
         }
         
         MA_Period = MathRound(MA_Period);

         MA = iMA(NULL, 0, MA_Period, 0, MA_Mode, PRICE_CLOSE, pos);

         if(!Use_StaircaseMode)
         {
            DynPeriodMA[pos] = MA;
         }
         else
         {
            DynPeriodMA[pos] = MathFloor(MA * MathPow(10,Digits) / PipPrecision) * PipPrecision / MathPow(10,Digits);
         }

         pos--; 
      }
   }
   else if(MA_Mode == 4)
   {
      while(pos>=0)
      {
         ATR = iATR(NULL, 0, DynPeriod, pos + LookBack);
      
         if (ATR != 0) {
            MA_Period = (1/ATR)  / Constant;
         } else {
            MA_Period = 1;
         }
         
         MA_Period = MathRound(MA_Period);
         
         if(MA_Period <=0) MA_Period = 1;
      
         MA = iCustom(NULL, 0, "JMA_StarLight", MA_Period, JMA_Phase, 0, 0, 0, pos);
      
         if(!Use_StaircaseMode)
         {
            DynPeriodMA[pos] = MA;
         }
         else
         {
            DynPeriodMA[pos] = MathFloor(MA * MathPow(10,Digits) / PipPrecision) * PipPrecision / MathPow(10,Digits);
         }
      
         pos--;
      }  
   }
}

//+------------------------------------------------------------------+
void ATRJMA()
{
   int counted_bars=IndicatorCounted();
//----
   int pos=Bars-counted_bars;

   double ATR;
   double MA;
   int MA_Period;
   
   if(Use_StaircaseMode == False) PipPrecision = 1;

   if(MA_Mode == 0 || MA_Mode == 1 || MA_Mode == 2 || MA_Mode == 3)
   {
      while(pos>=0)
      { 
         ATR = iCustom(NULL, 0, "JCC - ATR + JMA", 0, DynPeriod, 0, pos + LookBack);        
 
         if (ATR != 0) {
            MA_Period = (1/ATR)  / Constant;
         } else {
            MA_Period = 1;
         }
         
         MA_Period = MathRound(MA_Period);

         MA = iMA(NULL, 0, MA_Period, 0, MA_Mode, PRICE_CLOSE, pos);

         if(!Use_StaircaseMode)
         {
            DynPeriodMA[pos] = MA;
         }
         else
         {
            DynPeriodMA[pos] = MathFloor(MA * MathPow(10,Digits) / PipPrecision) * PipPrecision / MathPow(10,Digits);
         }

         pos--; 
      }
   }
   else if(MA_Mode == 4)
   {
      while(pos>=0)
      {
         ATR = iCustom(NULL, 0, "JCC - ATR + JMA", 0, 14, 0, pos + LookBack);
      
         if (ATR != 0) {
            MA_Period = (1/ATR)  / Constant;
         } else {
            MA_Period = 1;
         }
         
         MA_Period = MathRound(MA_Period);
         
         if(MA_Period <=0) MA_Period = 1;
      
         MA = iCustom(NULL, 0, "JMA_StarLight", MA_Period, JMA_Phase, 0, 0, 0, pos);
      
         if(!Use_StaircaseMode)
         {
            DynPeriodMA[pos] = MA;
         }
         else
         {
            DynPeriodMA[pos] = MathFloor(MA * MathPow(10,Digits) / PipPrecision) * PipPrecision / MathPow(10,Digits);
         }
      
         pos--;
      }  
   }
}

//+------------------------------------------------------------------+
void StdDevMA()
{
   int counted_bars=IndicatorCounted();
//----
   int pos=Bars-counted_bars;

   double StdDev;
   double MA;
   int MA_Period;
   
   if(Use_StaircaseMode == False) PipPrecision = 1;

   if(MA_Mode == 0 || MA_Mode == 1 || MA_Mode == 2 || MA_Mode == 3)
   {
      while(pos>=0)
      { 
         StdDev = iStdDev(NULL, 0, DynPeriod, 0, MODE_SMA, PRICE_CLOSE, pos + LookBack);      
 
         if (StdDev != 0) {
            MA_Period = (1/StdDev)  / Constant;
         } else {
            MA_Period = 1;
         }
         
         MA_Period = MathRound(MA_Period);

         MA = iMA(NULL, 0, MA_Period, 0, MA_Mode, PRICE_CLOSE, pos);

         if(!Use_StaircaseMode)
         {
            DynPeriodMA[pos] = MA;
         }
         else
         {
            DynPeriodMA[pos] = MathFloor(MA * MathPow(10,Digits) / PipPrecision) * PipPrecision / MathPow(10,Digits);
         }

         pos--; 
      }
   }
   else if(MA_Mode == 4)
   {
      while(pos>=0)
      {
         StdDev = iStdDev(NULL, 0, DynPeriod, 0, MODE_SMA, PRICE_CLOSE, pos + LookBack);
      
         if (StdDev != 0) {
            MA_Period = (1/StdDev)  / Constant;
         } else {
            MA_Period = 1;
         }
         
         MA_Period = MathRound(MA_Period);
         
         if(MA_Period <=0) MA_Period = 1;
      
         MA = iCustom(NULL, 0, "JMA_StarLight", MA_Period, JMA_Phase, 0, 0, 0, pos);
      
         if(!Use_StaircaseMode)
         {
            DynPeriodMA[pos] = MA;
         }
         else
         {
            DynPeriodMA[pos] = MathFloor(MA * MathPow(10,Digits) / PipPrecision) * PipPrecision / MathPow(10,Digits);
         }
      
         pos--;
      }  
   }
}
//+----------------------------------------------------------------------------+

void SimpleMA()
{
   int counted_bars=IndicatorCounted();
//----
   int pos=Bars-counted_bars;

   double MA;
   
   if(Use_StaircaseMode == False) PipPrecision = 1;

   if(MA_Mode == 0 || MA_Mode == 1 || MA_Mode == 2 || MA_Mode == 3)
   {
      while(pos>=0)
      {         
         MA = iMA(NULL, 0, DynPeriod, 0, MA_Mode, PRICE_CLOSE, pos);
         
         if(!Use_StaircaseMode)
         {
            DynPeriodMA[pos] = MA;
         }
         else
         {
            DynPeriodMA[pos] = MathFloor(MA * MathPow(10,Digits) / PipPrecision) * PipPrecision / MathPow(10,Digits);
         }
         
         pos--; 
      }

   }
   else if(MA_Mode == 4)
   {
      while(pos>=0)
      {
         MA = iCustom(NULL, 0, "JMA_StarLight", DynPeriod, JMA_Phase, 0, 0, 0, pos);
      
         if(!Use_StaircaseMode)
         {
            DynPeriodMA[pos] = MA;
         }
         else
         {
            DynPeriodMA[pos] = MathFloor(MA * MathPow(10,Digits) / PipPrecision) * PipPrecision / MathPow(10,Digits);
         }
      
         pos--;
      }  
   }
}